/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.client.OutlineRender;
import xfacthd.framedblocks.common.blockentity.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public final class CollapsibleBlockOutlineRenderer
implements OutlineRender {
    private static final Quaternion ROTATION = Vector3f.f_122224_.m_122240_(180.0f);

    @Override
    public void rotateMatrix(PoseStack poseStack, BlockState state) {
        poseStack.m_85845_(ROTATION);
    }

    @Override
    public void draw(BlockState state, Level level, BlockPos pos, PoseStack poseStack, VertexConsumer builder) {
        NullableDirection face = (NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE));
        if (face == NullableDirection.NONE) {
            Shapes.m_83144_().m_83224_((pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ) -> OutlineRender.drawLine(builder, poseStack, pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ));
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof FramedCollapsibleBlockEntity)) {
                return;
            }
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            byte[] offets = be.getVertexOffsets();
            Direction faceDir = face.toDirection().m_122424_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            if (faceDir == Direction.UP) {
                poseStack.m_85845_(Quaternions.XP_180);
            } else if (faceDir != Direction.DOWN) {
                poseStack.m_85845_(OutlineRender.YN_DIR[faceDir.m_122424_().m_122416_()]);
                poseStack.m_85845_(Quaternions.XN_90);
            }
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            OutlineRender.drawLine(builder, poseStack, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0);
            OutlineRender.drawLine(builder, poseStack, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0);
            OutlineRender.drawLine(builder, poseStack, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            OutlineRender.drawLine(builder, poseStack, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            OutlineRender.drawLine(builder, poseStack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, poseStack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, poseStack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, poseStack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, poseStack, 1.0, 0.0, 1.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            OutlineRender.drawLine(builder, poseStack, 1.0, 0.0, 0.0, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0);
            OutlineRender.drawLine(builder, poseStack, 0.0, 0.0, 0.0, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0);
            OutlineRender.drawLine(builder, poseStack, 0.0, 0.0, 1.0, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0);
            poseStack.m_85849_();
        }
    }

    @Override
    public void draw(BlockState state, PoseStack poseStack, VertexConsumer builder) {
        throw new UnsupportedOperationException();
    }
}

